/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.core;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.util.EclipseUtil;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.internal.core.ServerManager;
import com.aptana.webserver.internal.core.builtin.LocalWebServer;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public class WebServerCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.webserver.core";
    private static WebServerCorePlugin plugin;
    private ServerManager serverManager;
    private LocalWebServer defaultWebServer;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job job = new Job("Restoring saved state of servers"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IPath location;
                    ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant(WebServerCorePlugin.PLUGIN_ID, (ISaveParticipant)new WorkspaceSaveParticipant());
                    if (lastState != null && (location = lastState.lookup((IPath)new Path("webservers"))) != null) {
                        ((ServerManager)WebServerCorePlugin.this.getServerManager()).loadState(WebServerCorePlugin.this.getStateLocation().append(location));
                    }
                    return Status.OK_STATUS;
                }
                catch (IllegalStateException e) {
                    return new Status(4, WebServerCorePlugin.PLUGIN_ID, e.getMessage(), (Throwable)e);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ResourcesPlugin.getWorkspace().removeSaveParticipant(PLUGIN_ID);
            this.serverManager = null;
            if (this.defaultWebServer != null) {
                this.defaultWebServer.stop(true, (IProgressMonitor)new NullProgressMonitor());
                this.defaultWebServer = null;
            }
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public static WebServerCorePlugin getDefault() {
        return plugin;
    }

    public synchronized IServerManager getServerManager() {
        if (this.serverManager == null) {
            this.serverManager = new ServerManager();
        }
        return this.serverManager;
    }

    public void saveServerConfigurations() {
        new DelayedSnapshotJob(((Workspace)ResourcesPlugin.getWorkspace()).getSaveManager()).schedule();
    }

    public IServer getBuiltinWebServer() {
        this.ensureDefaultWebServer();
        return this.defaultWebServer;
    }

    private synchronized void ensureDefaultWebServer() {
        if (this.defaultWebServer == null) {
            this.defaultWebServer = new LocalWebServer(EFSUtils.getFileStore((IResource)ResourcesPlugin.getWorkspace().getRoot()).toURI());
        }
    }

    private class WorkspaceSaveParticipant
    implements ISaveParticipant {
        private WorkspaceSaveParticipant() {
        }

        public void doneSaving(ISaveContext context) {
            IPath prevSavePath = new Path("webservers").addFileExtension(Integer.toString(context.getPreviousSaveNumber()));
            WebServerCorePlugin.this.getStateLocation().append(prevSavePath).toFile().delete();
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
            IPath savePath = new Path("webservers").addFileExtension(Integer.toString(context.getSaveNumber()));
            WebServerCorePlugin.this.getStateLocation().append(savePath).toFile().delete();
        }

        public void saving(ISaveContext context) throws CoreException {
            IPath savePath = new Path("webservers").addFileExtension(Integer.toString(context.getSaveNumber()));
            ((ServerManager)WebServerCorePlugin.this.getServerManager()).saveState(WebServerCorePlugin.this.getStateLocation().append(savePath));
            context.map((IPath)new Path("webservers"), savePath);
            context.needSaveNumber();
        }
    }
}

